package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait WirelessGatewayIdType {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType
}
object WirelessGatewayIdType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType
  ): zio.aws.iotwireless.model.WirelessGatewayIdType = value match {
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType.GATEWAY_EUI =>
      val r = GatewayEui
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType.WIRELESS_GATEWAY_ID =>
      val r = WirelessGatewayId
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType.THING_NAME =>
      val r = ThingName
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.WirelessGatewayIdType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType.UNKNOWN_TO_SDK_VERSION
  }
  case object GatewayEui
      extends zio.aws.iotwireless.model.WirelessGatewayIdType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType.GATEWAY_EUI
  }
  case object WirelessGatewayId
      extends zio.aws.iotwireless.model.WirelessGatewayIdType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType.WIRELESS_GATEWAY_ID
  }
  case object ThingName
      extends zio.aws.iotwireless.model.WirelessGatewayIdType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType.THING_NAME
  }
}
