package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  AppSKey,
  NwkSEncKey,
  SNwkSIntKey,
  FNwkSIntKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SessionKeysAbpV1_1(
    fNwkSIntKey: Optional[FNwkSIntKey] = Optional.Absent,
    sNwkSIntKey: Optional[SNwkSIntKey] = Optional.Absent,
    nwkSEncKey: Optional[NwkSEncKey] = Optional.Absent,
    appSKey: Optional[AppSKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_1 = {
    import SessionKeysAbpV1_1.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_1
      .builder()
      .optionallyWith(
        fNwkSIntKey.map(value => FNwkSIntKey.unwrap(value): java.lang.String)
      )(_.fNwkSIntKey)
      .optionallyWith(
        sNwkSIntKey.map(value => SNwkSIntKey.unwrap(value): java.lang.String)
      )(_.sNwkSIntKey)
      .optionallyWith(
        nwkSEncKey.map(value => NwkSEncKey.unwrap(value): java.lang.String)
      )(_.nwkSEncKey)
      .optionallyWith(
        appSKey.map(value => AppSKey.unwrap(value): java.lang.String)
      )(_.appSKey)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly =
    zio.aws.iotwireless.model.SessionKeysAbpV1_1.wrap(buildAwsValue())
}
object SessionKeysAbpV1_1 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_1
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SessionKeysAbpV1_1 =
      zio.aws.iotwireless.model.SessionKeysAbpV1_1(
        fNwkSIntKey.map(value => value),
        sNwkSIntKey.map(value => value),
        nwkSEncKey.map(value => value),
        appSKey.map(value => value)
      )
    def fNwkSIntKey: Optional[FNwkSIntKey]
    def sNwkSIntKey: Optional[SNwkSIntKey]
    def nwkSEncKey: Optional[NwkSEncKey]
    def appSKey: Optional[AppSKey]
    def getFNwkSIntKey: ZIO[Any, AwsError, FNwkSIntKey] =
      AwsError.unwrapOptionField("fNwkSIntKey", fNwkSIntKey)
    def getSNwkSIntKey: ZIO[Any, AwsError, SNwkSIntKey] =
      AwsError.unwrapOptionField("sNwkSIntKey", sNwkSIntKey)
    def getNwkSEncKey: ZIO[Any, AwsError, NwkSEncKey] =
      AwsError.unwrapOptionField("nwkSEncKey", nwkSEncKey)
    def getAppSKey: ZIO[Any, AwsError, AppSKey] =
      AwsError.unwrapOptionField("appSKey", appSKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_1
  ) extends zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly {
    override val fNwkSIntKey: Optional[FNwkSIntKey] = zio.aws.core.internal
      .optionalFromNullable(impl.fNwkSIntKey())
      .map(value => zio.aws.iotwireless.model.primitives.FNwkSIntKey(value))
    override val sNwkSIntKey: Optional[SNwkSIntKey] = zio.aws.core.internal
      .optionalFromNullable(impl.sNwkSIntKey())
      .map(value => zio.aws.iotwireless.model.primitives.SNwkSIntKey(value))
    override val nwkSEncKey: Optional[NwkSEncKey] = zio.aws.core.internal
      .optionalFromNullable(impl.nwkSEncKey())
      .map(value => zio.aws.iotwireless.model.primitives.NwkSEncKey(value))
    override val appSKey: Optional[AppSKey] = zio.aws.core.internal
      .optionalFromNullable(impl.appSKey())
      .map(value => zio.aws.iotwireless.model.primitives.AppSKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_1
  ): zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly = new Wrapper(impl)
}
