package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.MulticastGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MulticastGroupByFuotaTask(
    id: Optional[MulticastGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.MulticastGroupByFuotaTask = {
    import MulticastGroupByFuotaTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.MulticastGroupByFuotaTask
      .builder()
      .optionallyWith(
        id.map(value => MulticastGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly =
    zio.aws.iotwireless.model.MulticastGroupByFuotaTask.wrap(buildAwsValue())
}
object MulticastGroupByFuotaTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.MulticastGroupByFuotaTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.MulticastGroupByFuotaTask =
      zio.aws.iotwireless.model
        .MulticastGroupByFuotaTask(id.map(value => value))
    def id: Optional[MulticastGroupId]
    def getId: ZIO[Any, AwsError, MulticastGroupId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.MulticastGroupByFuotaTask
  ) extends zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly {
    override val id: Optional[MulticastGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.MulticastGroupByFuotaTask
  ): zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly = new Wrapper(
    impl
  )
}
