package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListNetworkAnalyzerConfigurationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    networkAnalyzerConfigurationList: Optional[
      Iterable[zio.aws.iotwireless.model.NetworkAnalyzerConfigurations]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse = {
    import ListNetworkAnalyzerConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        networkAnalyzerConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkAnalyzerConfigurationList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse.ReadOnly =
    zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListNetworkAnalyzerConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse =
      zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse(
        nextToken.map(value => value),
        networkAnalyzerConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def networkAnalyzerConfigurationList: Optional[
      List[zio.aws.iotwireless.model.NetworkAnalyzerConfigurations.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNetworkAnalyzerConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.NetworkAnalyzerConfigurations.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkAnalyzerConfigurationList",
      networkAnalyzerConfigurationList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse
  ) extends zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val networkAnalyzerConfigurationList: Optional[
      List[zio.aws.iotwireless.model.NetworkAnalyzerConfigurations.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkAnalyzerConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.NetworkAnalyzerConfigurations.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse
  ): zio.aws.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
