package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessDeviceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWirelessDeviceStatisticsRequest(
    wirelessDeviceId: WirelessDeviceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest = {
    import GetWirelessDeviceStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest
      .builder()
      .wirelessDeviceId(
        WirelessDeviceId.unwrap(wirelessDeviceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessDeviceStatisticsRequest.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessDeviceStatisticsRequest
      .wrap(buildAwsValue())
}
object GetWirelessDeviceStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessDeviceStatisticsRequest =
      zio.aws.iotwireless.model
        .GetWirelessDeviceStatisticsRequest(wirelessDeviceId)
    def wirelessDeviceId: WirelessDeviceId
    def getWirelessDeviceId: ZIO[Any, Nothing, WirelessDeviceId] =
      ZIO.succeed(wirelessDeviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest
  ) extends zio.aws.iotwireless.model.GetWirelessDeviceStatisticsRequest.ReadOnly {
    override val wirelessDeviceId: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives
        .WirelessDeviceId(impl.wirelessDeviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsRequest
  ): zio.aws.iotwireless.model.GetWirelessDeviceStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
