package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.MulticastGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMulticastGroupSessionRequest(id: MulticastGroupId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionRequest = {
    import GetMulticastGroupSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetMulticastGroupSessionRequest.ReadOnly =
    zio.aws.iotwireless.model.GetMulticastGroupSessionRequest
      .wrap(buildAwsValue())
}
object GetMulticastGroupSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetMulticastGroupSessionRequest =
      zio.aws.iotwireless.model.GetMulticastGroupSessionRequest(id)
    def id: MulticastGroupId
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionRequest
  ) extends zio.aws.iotwireless.model.GetMulticastGroupSessionRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupSessionRequest
  ): zio.aws.iotwireless.model.GetMulticastGroupSessionRequest.ReadOnly =
    new Wrapper(impl)
}
