package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ClientRequestToken,
  Description,
  MulticastGroupName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMulticastGroupRequest(
    name: Optional[MulticastGroupName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    loRaWAN: zio.aws.iotwireless.model.LoRaWANMulticast,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest = {
    import CreateMulticastGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest
      .builder()
      .optionallyWith(
        name.map(value => MulticastGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .loRaWAN(loRaWAN.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateMulticastGroupRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateMulticastGroupRequest.wrap(buildAwsValue())
}
object CreateMulticastGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateMulticastGroupRequest =
      zio.aws.iotwireless.model.CreateMulticastGroupRequest(
        name.map(value => value),
        description.map(value => value),
        clientRequestToken.map(value => value),
        loRaWAN.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[MulticastGroupName]
    def description: Optional[Description]
    def clientRequestToken: Optional[ClientRequestToken]
    def loRaWAN: zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def getName: ZIO[Any, AwsError, MulticastGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLoRaWAN: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly
    ] = ZIO.succeed(loRaWAN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest
  ) extends zio.aws.iotwireless.model.CreateMulticastGroupRequest.ReadOnly {
    override val name: Optional[MulticastGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupName(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
        )
    override val loRaWAN: zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly =
      zio.aws.iotwireless.model.LoRaWANMulticast.wrap(impl.loRaWAN())
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupRequest
  ): zio.aws.iotwireless.model.CreateMulticastGroupRequest.ReadOnly =
    new Wrapper(impl)
}
