package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  BaseStationId,
  PilotPower,
  CdmaChannel,
  PnOffset
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CdmaNmrObj(
    pnOffset: PnOffset,
    cdmaChannel: CdmaChannel,
    pilotPower: Optional[PilotPower] = Optional.Absent,
    baseStationId: Optional[BaseStationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CdmaNmrObj = {
    import CdmaNmrObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CdmaNmrObj
      .builder()
      .pnOffset(PnOffset.unwrap(pnOffset): Integer)
      .cdmaChannel(CdmaChannel.unwrap(cdmaChannel): Integer)
      .optionallyWith(
        pilotPower.map(value => PilotPower.unwrap(value): Integer)
      )(_.pilotPower)
      .optionallyWith(
        baseStationId.map(value => BaseStationId.unwrap(value): Integer)
      )(_.baseStationId)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CdmaNmrObj.ReadOnly =
    zio.aws.iotwireless.model.CdmaNmrObj.wrap(buildAwsValue())
}
object CdmaNmrObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CdmaNmrObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CdmaNmrObj =
      zio.aws.iotwireless.model.CdmaNmrObj(
        pnOffset,
        cdmaChannel,
        pilotPower.map(value => value),
        baseStationId.map(value => value)
      )
    def pnOffset: PnOffset
    def cdmaChannel: CdmaChannel
    def pilotPower: Optional[PilotPower]
    def baseStationId: Optional[BaseStationId]
    def getPnOffset: ZIO[Any, Nothing, PnOffset] = ZIO.succeed(pnOffset)
    def getCdmaChannel: ZIO[Any, Nothing, CdmaChannel] =
      ZIO.succeed(cdmaChannel)
    def getPilotPower: ZIO[Any, AwsError, PilotPower] =
      AwsError.unwrapOptionField("pilotPower", pilotPower)
    def getBaseStationId: ZIO[Any, AwsError, BaseStationId] =
      AwsError.unwrapOptionField("baseStationId", baseStationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CdmaNmrObj
  ) extends zio.aws.iotwireless.model.CdmaNmrObj.ReadOnly {
    override val pnOffset: PnOffset =
      zio.aws.iotwireless.model.primitives.PnOffset(impl.pnOffset())
    override val cdmaChannel: CdmaChannel =
      zio.aws.iotwireless.model.primitives.CdmaChannel(impl.cdmaChannel())
    override val pilotPower: Optional[PilotPower] = zio.aws.core.internal
      .optionalFromNullable(impl.pilotPower())
      .map(value => zio.aws.iotwireless.model.primitives.PilotPower(value))
    override val baseStationId: Optional[BaseStationId] = zio.aws.core.internal
      .optionalFromNullable(impl.baseStationId())
      .map(value => zio.aws.iotwireless.model.primitives.BaseStationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CdmaNmrObj
  ): zio.aws.iotwireless.model.CdmaNmrObj.ReadOnly = new Wrapper(impl)
}
