package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{ThingArn, WirelessDeviceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateWirelessDeviceWithThingRequest(
    id: WirelessDeviceId,
    thingArn: ThingArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest = {
    import AssociateWirelessDeviceWithThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest
      .builder()
      .id(WirelessDeviceId.unwrap(id): java.lang.String)
      .thingArn(ThingArn.unwrap(thingArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingRequest.ReadOnly =
    zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingRequest
      .wrap(buildAwsValue())
}
object AssociateWirelessDeviceWithThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingRequest =
      zio.aws.iotwireless.model
        .AssociateWirelessDeviceWithThingRequest(id, thingArn)
    def id: WirelessDeviceId
    def thingArn: ThingArn
    def getId: ZIO[Any, Nothing, WirelessDeviceId] = ZIO.succeed(id)
    def getThingArn: ZIO[Any, Nothing, ThingArn] = ZIO.succeed(thingArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest
  ) extends zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingRequest.ReadOnly {
    override val id: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId(impl.id())
    override val thingArn: ThingArn =
      zio.aws.iotwireless.model.primitives.ThingArn(impl.thingArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithThingRequest
  ): zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingRequest.ReadOnly =
    new Wrapper(impl)
}
