package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.PartnerAccountArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateAwsAccountWithPartnerAccountResponse(
    sidewalk: Optional[zio.aws.iotwireless.model.SidewalkAccountInfo] =
      Optional.Absent,
    arn: Optional[PartnerAccountArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse = {
    import AssociateAwsAccountWithPartnerAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
      .builder()
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .optionallyWith(
        arn.map(value => PartnerAccountArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly =
    zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
      .wrap(buildAwsValue())
}
object AssociateAwsAccountWithPartnerAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse =
      zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse(
        sidewalk.map(value => value.asEditable),
        arn.map(value => value)
      )
    def sidewalk
        : Optional[zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly]
    def arn: Optional[PartnerAccountArn]
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
    def getArn: ZIO[Any, AwsError, PartnerAccountArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
  ) extends zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly {
    override val sidewalk
        : Optional[zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sidewalk())
        .map(value => zio.aws.iotwireless.model.SidewalkAccountInfo.wrap(value))
    override val arn: Optional[PartnerAccountArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.PartnerAccountArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
  ): zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly =
    new Wrapper(impl)
}
