package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{RSS, MacAddress}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WiFiAccessPoint(macAddress: MacAddress, rss: RSS) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WiFiAccessPoint = {
    import WiFiAccessPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WiFiAccessPoint
      .builder()
      .macAddress(MacAddress.unwrap(macAddress): java.lang.String)
      .rss(RSS.unwrap(rss): Integer)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WiFiAccessPoint.ReadOnly =
    zio.aws.iotwireless.model.WiFiAccessPoint.wrap(buildAwsValue())
}
object WiFiAccessPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WiFiAccessPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WiFiAccessPoint =
      zio.aws.iotwireless.model.WiFiAccessPoint(macAddress, rss)
    def macAddress: MacAddress
    def rss: RSS
    def getMacAddress: ZIO[Any, Nothing, MacAddress] = ZIO.succeed(macAddress)
    def getRss: ZIO[Any, Nothing, RSS] = ZIO.succeed(rss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WiFiAccessPoint
  ) extends zio.aws.iotwireless.model.WiFiAccessPoint.ReadOnly {
    override val macAddress: MacAddress =
      zio.aws.iotwireless.model.primitives.MacAddress(impl.macAddress())
    override val rss: RSS = zio.aws.iotwireless.model.primitives.RSS(impl.rss())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WiFiAccessPoint
  ): zio.aws.iotwireless.model.WiFiAccessPoint.ReadOnly = new Wrapper(impl)
}
