package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  FirmwareUpdateRole,
  FirmwareUpdateImage,
  FuotaTaskName,
  Description,
  FuotaTaskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFuotaTaskRequest(
    id: FuotaTaskId,
    name: Optional[FuotaTaskName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask] =
      Optional.Absent,
    firmwareUpdateImage: Optional[FirmwareUpdateImage] = Optional.Absent,
    firmwareUpdateRole: Optional[FirmwareUpdateRole] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest = {
    import UpdateFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => FuotaTaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        firmwareUpdateImage.map(value =>
          FirmwareUpdateImage.unwrap(value): java.lang.String
        )
      )(_.firmwareUpdateImage)
      .optionallyWith(
        firmwareUpdateRole.map(value =>
          FirmwareUpdateRole.unwrap(value): java.lang.String
        )
      )(_.firmwareUpdateRole)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.UpdateFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateFuotaTaskRequest.wrap(buildAwsValue())
}
object UpdateFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateFuotaTaskRequest =
      zio.aws.iotwireless.model.UpdateFuotaTaskRequest(
        id,
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable),
        firmwareUpdateImage.map(value => value),
        firmwareUpdateRole.map(value => value)
      )
    def id: FuotaTaskId
    def name: Optional[FuotaTaskName]
    def description: Optional[Description]
    def loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly]
    def firmwareUpdateImage: Optional[FirmwareUpdateImage]
    def firmwareUpdateRole: Optional[FirmwareUpdateRole]
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, FuotaTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getFirmwareUpdateImage: ZIO[Any, AwsError, FirmwareUpdateImage] =
      AwsError.unwrapOptionField("firmwareUpdateImage", firmwareUpdateImage)
    def getFirmwareUpdateRole: ZIO[Any, AwsError, FirmwareUpdateRole] =
      AwsError.unwrapOptionField("firmwareUpdateRole", firmwareUpdateRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.UpdateFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
    override val name: Optional[FuotaTaskName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANFuotaTask.wrap(value))
    override val firmwareUpdateImage: Optional[FirmwareUpdateImage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firmwareUpdateImage())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FirmwareUpdateImage(value)
        )
    override val firmwareUpdateRole: Optional[FirmwareUpdateRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firmwareUpdateRole())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FirmwareUpdateRole(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateFuotaTaskRequest
  ): zio.aws.iotwireless.model.UpdateFuotaTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
