package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.FCntStart
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateAbpV1_1(
    fCntStart: Optional[FCntStart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_1 = {
    import UpdateAbpV1_1.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_1
      .builder()
      .optionallyWith(fCntStart.map(value => FCntStart.unwrap(value): Integer))(
        _.fCntStart
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.UpdateAbpV1_1.ReadOnly =
    zio.aws.iotwireless.model.UpdateAbpV1_1.wrap(buildAwsValue())
}
object UpdateAbpV1_1 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_1
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateAbpV1_1 =
      zio.aws.iotwireless.model.UpdateAbpV1_1(fCntStart.map(value => value))
    def fCntStart: Optional[FCntStart]
    def getFCntStart: ZIO[Any, AwsError, FCntStart] =
      AwsError.unwrapOptionField("fCntStart", fCntStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_1
  ) extends zio.aws.iotwireless.model.UpdateAbpV1_1.ReadOnly {
    override val fCntStart: Optional[FCntStart] = zio.aws.core.internal
      .optionalFromNullable(impl.fCntStart())
      .map(value => zio.aws.iotwireless.model.primitives.FCntStart(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_1
  ): zio.aws.iotwireless.model.UpdateAbpV1_1.ReadOnly = new Wrapper(impl)
}
