package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  UtranCid,
  LAC,
  PathLoss,
  TdscdmaTimingAdvance,
  MCC,
  RSCP,
  MNC
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TdscdmaObj(
    mcc: MCC,
    mnc: MNC,
    lac: Optional[LAC] = Optional.Absent,
    utranCid: UtranCid,
    tdscdmaLocalId: Optional[zio.aws.iotwireless.model.TdscdmaLocalId] =
      Optional.Absent,
    tdscdmaTimingAdvance: Optional[TdscdmaTimingAdvance] = Optional.Absent,
    rscp: Optional[RSCP] = Optional.Absent,
    pathLoss: Optional[PathLoss] = Optional.Absent,
    tdscdmaNmr: Optional[Iterable[zio.aws.iotwireless.model.TdscdmaNmrObj]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.TdscdmaObj = {
    import TdscdmaObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.TdscdmaObj
      .builder()
      .mcc(MCC.unwrap(mcc): Integer)
      .mnc(MNC.unwrap(mnc): Integer)
      .optionallyWith(lac.map(value => LAC.unwrap(value): Integer))(_.lac)
      .utranCid(UtranCid.unwrap(utranCid): Integer)
      .optionallyWith(tdscdmaLocalId.map(value => value.buildAwsValue()))(
        _.tdscdmaLocalId
      )
      .optionallyWith(
        tdscdmaTimingAdvance.map(value =>
          TdscdmaTimingAdvance.unwrap(value): Integer
        )
      )(_.tdscdmaTimingAdvance)
      .optionallyWith(rscp.map(value => RSCP.unwrap(value): Integer))(_.rscp)
      .optionallyWith(pathLoss.map(value => PathLoss.unwrap(value): Integer))(
        _.pathLoss
      )
      .optionallyWith(
        tdscdmaNmr.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tdscdmaNmr)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.TdscdmaObj.ReadOnly =
    zio.aws.iotwireless.model.TdscdmaObj.wrap(buildAwsValue())
}
object TdscdmaObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.TdscdmaObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.TdscdmaObj =
      zio.aws.iotwireless.model.TdscdmaObj(
        mcc,
        mnc,
        lac.map(value => value),
        utranCid,
        tdscdmaLocalId.map(value => value.asEditable),
        tdscdmaTimingAdvance.map(value => value),
        rscp.map(value => value),
        pathLoss.map(value => value),
        tdscdmaNmr.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def mcc: MCC
    def mnc: MNC
    def lac: Optional[LAC]
    def utranCid: UtranCid
    def tdscdmaLocalId
        : Optional[zio.aws.iotwireless.model.TdscdmaLocalId.ReadOnly]
    def tdscdmaTimingAdvance: Optional[TdscdmaTimingAdvance]
    def rscp: Optional[RSCP]
    def pathLoss: Optional[PathLoss]
    def tdscdmaNmr
        : Optional[List[zio.aws.iotwireless.model.TdscdmaNmrObj.ReadOnly]]
    def getMcc: ZIO[Any, Nothing, MCC] = ZIO.succeed(mcc)
    def getMnc: ZIO[Any, Nothing, MNC] = ZIO.succeed(mnc)
    def getLac: ZIO[Any, AwsError, LAC] = AwsError.unwrapOptionField("lac", lac)
    def getUtranCid: ZIO[Any, Nothing, UtranCid] = ZIO.succeed(utranCid)
    def getTdscdmaLocalId: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.TdscdmaLocalId.ReadOnly
    ] = AwsError.unwrapOptionField("tdscdmaLocalId", tdscdmaLocalId)
    def getTdscdmaTimingAdvance: ZIO[Any, AwsError, TdscdmaTimingAdvance] =
      AwsError.unwrapOptionField("tdscdmaTimingAdvance", tdscdmaTimingAdvance)
    def getRscp: ZIO[Any, AwsError, RSCP] =
      AwsError.unwrapOptionField("rscp", rscp)
    def getPathLoss: ZIO[Any, AwsError, PathLoss] =
      AwsError.unwrapOptionField("pathLoss", pathLoss)
    def getTdscdmaNmr: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.TdscdmaNmrObj.ReadOnly
    ]] = AwsError.unwrapOptionField("tdscdmaNmr", tdscdmaNmr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.TdscdmaObj
  ) extends zio.aws.iotwireless.model.TdscdmaObj.ReadOnly {
    override val mcc: MCC = zio.aws.iotwireless.model.primitives.MCC(impl.mcc())
    override val mnc: MNC = zio.aws.iotwireless.model.primitives.MNC(impl.mnc())
    override val lac: Optional[LAC] = zio.aws.core.internal
      .optionalFromNullable(impl.lac())
      .map(value => zio.aws.iotwireless.model.primitives.LAC(value))
    override val utranCid: UtranCid =
      zio.aws.iotwireless.model.primitives.UtranCid(impl.utranCid())
    override val tdscdmaLocalId
        : Optional[zio.aws.iotwireless.model.TdscdmaLocalId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tdscdmaLocalId())
        .map(value => zio.aws.iotwireless.model.TdscdmaLocalId.wrap(value))
    override val tdscdmaTimingAdvance: Optional[TdscdmaTimingAdvance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tdscdmaTimingAdvance())
        .map(value =>
          zio.aws.iotwireless.model.primitives.TdscdmaTimingAdvance(value)
        )
    override val rscp: Optional[RSCP] = zio.aws.core.internal
      .optionalFromNullable(impl.rscp())
      .map(value => zio.aws.iotwireless.model.primitives.RSCP(value))
    override val pathLoss: Optional[PathLoss] = zio.aws.core.internal
      .optionalFromNullable(impl.pathLoss())
      .map(value => zio.aws.iotwireless.model.primitives.PathLoss(value))
    override val tdscdmaNmr
        : Optional[List[zio.aws.iotwireless.model.TdscdmaNmrObj.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tdscdmaNmr())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.TdscdmaNmrObj.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.TdscdmaObj
  ): zio.aws.iotwireless.model.TdscdmaObj.ReadOnly = new Wrapper(impl)
}
