package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  UtranCid,
  CellParams,
  UARFCN,
  PathLoss,
  RSCP
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TdscdmaNmrObj(
    uarfcn: UARFCN,
    cellParams: CellParams,
    utranCid: Optional[UtranCid] = Optional.Absent,
    rscp: Optional[RSCP] = Optional.Absent,
    pathLoss: Optional[PathLoss] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.TdscdmaNmrObj = {
    import TdscdmaNmrObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.TdscdmaNmrObj
      .builder()
      .uarfcn(UARFCN.unwrap(uarfcn): Integer)
      .cellParams(CellParams.unwrap(cellParams): Integer)
      .optionallyWith(utranCid.map(value => UtranCid.unwrap(value): Integer))(
        _.utranCid
      )
      .optionallyWith(rscp.map(value => RSCP.unwrap(value): Integer))(_.rscp)
      .optionallyWith(pathLoss.map(value => PathLoss.unwrap(value): Integer))(
        _.pathLoss
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.TdscdmaNmrObj.ReadOnly =
    zio.aws.iotwireless.model.TdscdmaNmrObj.wrap(buildAwsValue())
}
object TdscdmaNmrObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.TdscdmaNmrObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.TdscdmaNmrObj =
      zio.aws.iotwireless.model.TdscdmaNmrObj(
        uarfcn,
        cellParams,
        utranCid.map(value => value),
        rscp.map(value => value),
        pathLoss.map(value => value)
      )
    def uarfcn: UARFCN
    def cellParams: CellParams
    def utranCid: Optional[UtranCid]
    def rscp: Optional[RSCP]
    def pathLoss: Optional[PathLoss]
    def getUarfcn: ZIO[Any, Nothing, UARFCN] = ZIO.succeed(uarfcn)
    def getCellParams: ZIO[Any, Nothing, CellParams] = ZIO.succeed(cellParams)
    def getUtranCid: ZIO[Any, AwsError, UtranCid] =
      AwsError.unwrapOptionField("utranCid", utranCid)
    def getRscp: ZIO[Any, AwsError, RSCP] =
      AwsError.unwrapOptionField("rscp", rscp)
    def getPathLoss: ZIO[Any, AwsError, PathLoss] =
      AwsError.unwrapOptionField("pathLoss", pathLoss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.TdscdmaNmrObj
  ) extends zio.aws.iotwireless.model.TdscdmaNmrObj.ReadOnly {
    override val uarfcn: UARFCN =
      zio.aws.iotwireless.model.primitives.UARFCN(impl.uarfcn())
    override val cellParams: CellParams =
      zio.aws.iotwireless.model.primitives.CellParams(impl.cellParams())
    override val utranCid: Optional[UtranCid] = zio.aws.core.internal
      .optionalFromNullable(impl.utranCid())
      .map(value => zio.aws.iotwireless.model.primitives.UtranCid(value))
    override val rscp: Optional[RSCP] = zio.aws.core.internal
      .optionalFromNullable(impl.rscp())
      .map(value => zio.aws.iotwireless.model.primitives.RSCP(value))
    override val pathLoss: Optional[PathLoss] = zio.aws.core.internal
      .optionalFromNullable(impl.pathLoss())
      .map(value => zio.aws.iotwireless.model.primitives.PathLoss(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.TdscdmaNmrObj
  ): zio.aws.iotwireless.model.TdscdmaNmrObj.ReadOnly = new Wrapper(impl)
}
