package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{GenAppKey, AppEui, AppKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OtaaV1_0_x(
    appKey: Optional[AppKey] = Optional.Absent,
    appEui: Optional[AppEui] = Optional.Absent,
    genAppKey: Optional[GenAppKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.OtaaV1_0_x = {
    import OtaaV1_0_x.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.OtaaV1_0_x
      .builder()
      .optionallyWith(
        appKey.map(value => AppKey.unwrap(value): java.lang.String)
      )(_.appKey)
      .optionallyWith(
        appEui.map(value => AppEui.unwrap(value): java.lang.String)
      )(_.appEui)
      .optionallyWith(
        genAppKey.map(value => GenAppKey.unwrap(value): java.lang.String)
      )(_.genAppKey)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.OtaaV1_0_x.ReadOnly =
    zio.aws.iotwireless.model.OtaaV1_0_x.wrap(buildAwsValue())
}
object OtaaV1_0_x {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.OtaaV1_0_x
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.OtaaV1_0_x =
      zio.aws.iotwireless.model.OtaaV1_0_x(
        appKey.map(value => value),
        appEui.map(value => value),
        genAppKey.map(value => value)
      )
    def appKey: Optional[AppKey]
    def appEui: Optional[AppEui]
    def genAppKey: Optional[GenAppKey]
    def getAppKey: ZIO[Any, AwsError, AppKey] =
      AwsError.unwrapOptionField("appKey", appKey)
    def getAppEui: ZIO[Any, AwsError, AppEui] =
      AwsError.unwrapOptionField("appEui", appEui)
    def getGenAppKey: ZIO[Any, AwsError, GenAppKey] =
      AwsError.unwrapOptionField("genAppKey", genAppKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.OtaaV1_0_x
  ) extends zio.aws.iotwireless.model.OtaaV1_0_x.ReadOnly {
    override val appKey: Optional[AppKey] = zio.aws.core.internal
      .optionalFromNullable(impl.appKey())
      .map(value => zio.aws.iotwireless.model.primitives.AppKey(value))
    override val appEui: Optional[AppEui] = zio.aws.core.internal
      .optionalFromNullable(impl.appEui())
      .map(value => zio.aws.iotwireless.model.primitives.AppEui(value))
    override val genAppKey: Optional[GenAppKey] = zio.aws.core.internal
      .optionalFromNullable(impl.genAppKey())
      .map(value => zio.aws.iotwireless.model.primitives.GenAppKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.OtaaV1_0_x
  ): zio.aws.iotwireless.model.OtaaV1_0_x.ReadOnly = new Wrapper(impl)
}
