package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  SubBand,
  NetId,
  JoinEui,
  GatewayEui,
  RfRegion
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoRaWANGateway(
    gatewayEui: Optional[GatewayEui] = Optional.Absent,
    rfRegion: Optional[RfRegion] = Optional.Absent,
    joinEuiFilters: Optional[Iterable[Iterable[JoinEui]]] = Optional.Absent,
    netIdFilters: Optional[Iterable[NetId]] = Optional.Absent,
    subBands: Optional[Iterable[SubBand]] = Optional.Absent,
    beaconing: Optional[zio.aws.iotwireless.model.Beaconing] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANGateway = {
    import LoRaWANGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGateway
      .builder()
      .optionallyWith(
        gatewayEui.map(value => GatewayEui.unwrap(value): java.lang.String)
      )(_.gatewayEui)
      .optionallyWith(
        rfRegion.map(value => RfRegion.unwrap(value): java.lang.String)
      )(_.rfRegion)
      .optionallyWith(
        joinEuiFilters.map(value =>
          value.map { item =>
            item.map { item =>
              JoinEui.unwrap(item): java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.joinEuiFilters)
      .optionallyWith(
        netIdFilters.map(value =>
          value.map { item =>
            NetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.netIdFilters)
      .optionallyWith(
        subBands.map(value =>
          value.map { item =>
            SubBand.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.subBands)
      .optionallyWith(beaconing.map(value => value.buildAwsValue()))(
        _.beaconing
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANGateway.wrap(buildAwsValue())
}
object LoRaWANGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANGateway =
      zio.aws.iotwireless.model.LoRaWANGateway(
        gatewayEui.map(value => value),
        rfRegion.map(value => value),
        joinEuiFilters.map(value => value),
        netIdFilters.map(value => value),
        subBands.map(value => value),
        beaconing.map(value => value.asEditable)
      )
    def gatewayEui: Optional[GatewayEui]
    def rfRegion: Optional[RfRegion]
    def joinEuiFilters: Optional[List[List[JoinEui]]]
    def netIdFilters: Optional[List[NetId]]
    def subBands: Optional[List[SubBand]]
    def beaconing: Optional[zio.aws.iotwireless.model.Beaconing.ReadOnly]
    def getGatewayEui: ZIO[Any, AwsError, GatewayEui] =
      AwsError.unwrapOptionField("gatewayEui", gatewayEui)
    def getRfRegion: ZIO[Any, AwsError, RfRegion] =
      AwsError.unwrapOptionField("rfRegion", rfRegion)
    def getJoinEuiFilters: ZIO[Any, AwsError, List[List[JoinEui]]] =
      AwsError.unwrapOptionField("joinEuiFilters", joinEuiFilters)
    def getNetIdFilters: ZIO[Any, AwsError, List[NetId]] =
      AwsError.unwrapOptionField("netIdFilters", netIdFilters)
    def getSubBands: ZIO[Any, AwsError, List[SubBand]] =
      AwsError.unwrapOptionField("subBands", subBands)
    def getBeaconing
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.Beaconing.ReadOnly] =
      AwsError.unwrapOptionField("beaconing", beaconing)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGateway
  ) extends zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly {
    override val gatewayEui: Optional[GatewayEui] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayEui())
      .map(value => zio.aws.iotwireless.model.primitives.GatewayEui(value))
    override val rfRegion: Optional[RfRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.rfRegion())
      .map(value => zio.aws.iotwireless.model.primitives.RfRegion(value))
    override val joinEuiFilters: Optional[List[List[JoinEui]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.joinEuiFilters())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.iotwireless.model.primitives.JoinEui(item)
            }.toList
          }.toList
        )
    override val netIdFilters: Optional[List[NetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.netIdFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.primitives.NetId(item)
        }.toList
      )
    override val subBands: Optional[List[SubBand]] = zio.aws.core.internal
      .optionalFromNullable(impl.subBands())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.primitives.SubBand(item)
        }.toList
      )
    override val beaconing
        : Optional[zio.aws.iotwireless.model.Beaconing.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.beaconing())
        .map(value => zio.aws.iotwireless.model.Beaconing.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGateway
  ): zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly = new Wrapper(impl)
}
