package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{ISODateTimeString, Integer, DevEui}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANDeviceMetadata(
    devEui: Optional[DevEui] = Optional.Absent,
    fPort: Optional[Integer] = Optional.Absent,
    dataRate: Optional[Integer] = Optional.Absent,
    frequency: Optional[Integer] = Optional.Absent,
    timestamp: Optional[ISODateTimeString] = Optional.Absent,
    gateways: Optional[
      Iterable[zio.aws.iotwireless.model.LoRaWANGatewayMetadata]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata = {
    import LoRaWANDeviceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata
      .builder()
      .optionallyWith(
        devEui.map(value => DevEui.unwrap(value): java.lang.String)
      )(_.devEui)
      .optionallyWith(fPort.map(value => value: java.lang.Integer))(_.fPort)
      .optionallyWith(dataRate.map(value => value: java.lang.Integer))(
        _.dataRate
      )
      .optionallyWith(frequency.map(value => value: java.lang.Integer))(
        _.frequency
      )
      .optionallyWith(
        timestamp.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.timestamp)
      .optionallyWith(
        gateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gateways)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANDeviceMetadata.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANDeviceMetadata.wrap(buildAwsValue())
}
object LoRaWANDeviceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANDeviceMetadata =
      zio.aws.iotwireless.model.LoRaWANDeviceMetadata(
        devEui.map(value => value),
        fPort.map(value => value),
        dataRate.map(value => value),
        frequency.map(value => value),
        timestamp.map(value => value),
        gateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def devEui: Optional[DevEui]
    def fPort: Optional[Integer]
    def dataRate: Optional[Integer]
    def frequency: Optional[Integer]
    def timestamp: Optional[ISODateTimeString]
    def gateways: Optional[
      List[zio.aws.iotwireless.model.LoRaWANGatewayMetadata.ReadOnly]
    ]
    def getDevEui: ZIO[Any, AwsError, DevEui] =
      AwsError.unwrapOptionField("devEui", devEui)
    def getFPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fPort", fPort)
    def getDataRate: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dataRate", dataRate)
    def getFrequency: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getTimestamp: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getGateways: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.LoRaWANGatewayMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("gateways", gateways)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata
  ) extends zio.aws.iotwireless.model.LoRaWANDeviceMetadata.ReadOnly {
    override val devEui: Optional[DevEui] = zio.aws.core.internal
      .optionalFromNullable(impl.devEui())
      .map(value => zio.aws.iotwireless.model.primitives.DevEui(value))
    override val fPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fPort())
      .map(value => value: Integer)
    override val dataRate: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dataRate())
      .map(value => value: Integer)
    override val frequency: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.frequency())
      .map(value => value: Integer)
    override val timestamp: Optional[ISODateTimeString] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
      )
    override val gateways: Optional[
      List[zio.aws.iotwireless.model.LoRaWANGatewayMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gateways())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.LoRaWANGatewayMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANDeviceMetadata
  ): zio.aws.iotwireless.model.LoRaWANDeviceMetadata.ReadOnly = new Wrapper(
    impl
  )
}
