package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  CaptureTimeAccuracy,
  GnssNav,
  GPST,
  Coordinate,
  Use2DSolver
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Gnss(
    payload: GnssNav,
    captureTime: Optional[GPST] = Optional.Absent,
    captureTimeAccuracy: Optional[CaptureTimeAccuracy] = Optional.Absent,
    assistPosition: Optional[Iterable[Coordinate]] = Optional.Absent,
    assistAltitude: Optional[Coordinate] = Optional.Absent,
    use2DSolver: Optional[Use2DSolver] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.Gnss = {
    import Gnss.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.Gnss
      .builder()
      .payload(GnssNav.unwrap(payload): java.lang.String)
      .optionallyWith(
        captureTime.map(value => GPST.unwrap(value): java.lang.Float)
      )(_.captureTime)
      .optionallyWith(
        captureTimeAccuracy.map(value =>
          CaptureTimeAccuracy.unwrap(value): java.lang.Float
        )
      )(_.captureTimeAccuracy)
      .optionallyWith(
        assistPosition.map(value =>
          value.map { item =>
            Coordinate.unwrap(item): java.lang.Float
          }.asJavaCollection
        )
      )(_.assistPosition)
      .optionallyWith(
        assistAltitude.map(value => Coordinate.unwrap(value): java.lang.Float)
      )(_.assistAltitude)
      .optionallyWith(
        use2DSolver.map(value => Use2DSolver.unwrap(value): java.lang.Boolean)
      )(_.use2DSolver)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.Gnss.ReadOnly =
    zio.aws.iotwireless.model.Gnss.wrap(buildAwsValue())
}
object Gnss {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iotwireless.model.Gnss] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.Gnss =
      zio.aws.iotwireless.model.Gnss(
        payload,
        captureTime.map(value => value),
        captureTimeAccuracy.map(value => value),
        assistPosition.map(value => value),
        assistAltitude.map(value => value),
        use2DSolver.map(value => value)
      )
    def payload: GnssNav
    def captureTime: Optional[GPST]
    def captureTimeAccuracy: Optional[CaptureTimeAccuracy]
    def assistPosition: Optional[List[Coordinate]]
    def assistAltitude: Optional[Coordinate]
    def use2DSolver: Optional[Use2DSolver]
    def getPayload: ZIO[Any, Nothing, GnssNav] = ZIO.succeed(payload)
    def getCaptureTime: ZIO[Any, AwsError, GPST] =
      AwsError.unwrapOptionField("captureTime", captureTime)
    def getCaptureTimeAccuracy: ZIO[Any, AwsError, CaptureTimeAccuracy] =
      AwsError.unwrapOptionField("captureTimeAccuracy", captureTimeAccuracy)
    def getAssistPosition: ZIO[Any, AwsError, List[Coordinate]] =
      AwsError.unwrapOptionField("assistPosition", assistPosition)
    def getAssistAltitude: ZIO[Any, AwsError, Coordinate] =
      AwsError.unwrapOptionField("assistAltitude", assistAltitude)
    def getUse2DSolver: ZIO[Any, AwsError, Use2DSolver] =
      AwsError.unwrapOptionField("use2DSolver", use2DSolver)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.Gnss
  ) extends zio.aws.iotwireless.model.Gnss.ReadOnly {
    override val payload: GnssNav =
      zio.aws.iotwireless.model.primitives.GnssNav(impl.payload())
    override val captureTime: Optional[GPST] = zio.aws.core.internal
      .optionalFromNullable(impl.captureTime())
      .map(value => zio.aws.iotwireless.model.primitives.GPST(value))
    override val captureTimeAccuracy: Optional[CaptureTimeAccuracy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captureTimeAccuracy())
        .map(value =>
          zio.aws.iotwireless.model.primitives.CaptureTimeAccuracy(value)
        )
    override val assistPosition: Optional[List[Coordinate]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assistPosition())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.Coordinate(item)
          }.toList
        )
    override val assistAltitude: Optional[Coordinate] = zio.aws.core.internal
      .optionalFromNullable(impl.assistAltitude())
      .map(value => zio.aws.iotwireless.model.primitives.Coordinate(value))
    override val use2DSolver: Optional[Use2DSolver] = zio.aws.core.internal
      .optionalFromNullable(impl.use2DSolver())
      .map(value => zio.aws.iotwireless.model.primitives.Use2DSolver(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.Gnss
  ): zio.aws.iotwireless.model.Gnss.ReadOnly = new Wrapper(impl)
}
