package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ThingName,
  ThingArn,
  WirelessGatewayId,
  WirelessGatewayArn,
  WirelessGatewayName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayResponse(
    name: Optional[WirelessGatewayName] = Optional.Absent,
    id: Optional[WirelessGatewayId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANGateway] =
      Optional.Absent,
    arn: Optional[WirelessGatewayArn] = Optional.Absent,
    thingName: Optional[ThingName] = Optional.Absent,
    thingArn: Optional[ThingArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse = {
    import GetWirelessGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse
      .builder()
      .optionallyWith(
        name.map(value => WirelessGatewayName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => WirelessGatewayId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        arn.map(value => WirelessGatewayArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayResponse.wrap(buildAwsValue())
}
object GetWirelessGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetWirelessGatewayResponse =
      zio.aws.iotwireless.model.GetWirelessGatewayResponse(
        name.map(value => value),
        id.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable),
        arn.map(value => value),
        thingName.map(value => value),
        thingArn.map(value => value)
      )
    def name: Optional[WirelessGatewayName]
    def id: Optional[WirelessGatewayId]
    def description: Optional[Description]
    def loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly]
    def arn: Optional[WirelessGatewayArn]
    def thingName: Optional[ThingName]
    def thingArn: Optional[ThingArn]
    def getName: ZIO[Any, AwsError, WirelessGatewayName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, WirelessGatewayId] =
      AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getArn: ZIO[Any, AwsError, WirelessGatewayArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly {
    override val name: Optional[WirelessGatewayName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayName(value)
      )
    override val id: Optional[WirelessGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayId(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANGateway.wrap(value))
    override val arn: Optional[WirelessGatewayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayArn(value)
      )
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value => zio.aws.iotwireless.model.primitives.ThingName(value))
    override val thingArn: Optional[ThingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value => zio.aws.iotwireless.model.primitives.ThingArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse
  ): zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
