package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.Identifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayRequest(
    identifier: Identifier,
    identifierType: zio.aws.iotwireless.model.WirelessGatewayIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest = {
    import GetWirelessGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest
      .builder()
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .identifierType(identifierType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetWirelessGatewayRequest.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayRequest.wrap(buildAwsValue())
}
object GetWirelessGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetWirelessGatewayRequest =
      zio.aws.iotwireless.model
        .GetWirelessGatewayRequest(identifier, identifierType)
    def identifier: Identifier
    def identifierType: zio.aws.iotwireless.model.WirelessGatewayIdType
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
    def getIdentifierType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.WirelessGatewayIdType] =
      ZIO.succeed(identifierType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayRequest.ReadOnly {
    override val identifier: Identifier =
      zio.aws.iotwireless.model.primitives.Identifier(impl.identifier())
    override val identifierType
        : zio.aws.iotwireless.model.WirelessGatewayIdType =
      zio.aws.iotwireless.model.WirelessGatewayIdType
        .wrap(impl.identifierType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayRequest
  ): zio.aws.iotwireless.model.GetWirelessGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
