package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourceLogLevelResponse(
    logLevel: Optional[zio.aws.iotwireless.model.LogLevel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelResponse = {
    import GetResourceLogLevelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelResponse
      .builder()
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetResourceLogLevelResponse.ReadOnly =
    zio.aws.iotwireless.model.GetResourceLogLevelResponse.wrap(buildAwsValue())
}
object GetResourceLogLevelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetResourceLogLevelResponse =
      zio.aws.iotwireless.model
        .GetResourceLogLevelResponse(logLevel.map(value => value))
    def logLevel: Optional[zio.aws.iotwireless.model.LogLevel]
    def getLogLevel: ZIO[Any, AwsError, zio.aws.iotwireless.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelResponse
  ) extends zio.aws.iotwireless.model.GetResourceLogLevelResponse.ReadOnly {
    override val logLevel: Optional[zio.aws.iotwireless.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevel())
        .map(value => zio.aws.iotwireless.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetResourceLogLevelResponse
  ): zio.aws.iotwireless.model.GetResourceLogLevelResponse.ReadOnly =
    new Wrapper(impl)
}
