package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait EventNotificationResourceType {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType
}
object EventNotificationResourceType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType
  ): zio.aws.iotwireless.model.EventNotificationResourceType = value match {
    case software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType.SIDEWALK_ACCOUNT =>
      val r = SidewalkAccount
      r
    case software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType.WIRELESS_DEVICE =>
      val r = WirelessDevice
      r
    case software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType.WIRELESS_GATEWAY =>
      val r = WirelessGateway
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.EventNotificationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType =
      software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object SidewalkAccount
      extends zio.aws.iotwireless.model.EventNotificationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType =
      software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType.SIDEWALK_ACCOUNT
  }
  case object WirelessDevice
      extends zio.aws.iotwireless.model.EventNotificationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType =
      software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType.WIRELESS_DEVICE
  }
  case object WirelessGateway
      extends zio.aws.iotwireless.model.EventNotificationResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType =
      software.amazon.awssdk.services.iotwireless.model.EventNotificationResourceType.WIRELESS_GATEWAY
  }
}
