package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait DeviceState {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.DeviceState
}
object DeviceState {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.DeviceState
  ): zio.aws.iotwireless.model.DeviceState = value match {
    case software.amazon.awssdk.services.iotwireless.model.DeviceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.DeviceState.PROVISIONED =>
      val r = Provisioned
      r
    case software.amazon.awssdk.services.iotwireless.model.DeviceState.REGISTERED_NOT_SEEN =>
      val r = RegisteredNotSeen
      r
    case software.amazon.awssdk.services.iotwireless.model.DeviceState.REGISTERED_REACHABLE =>
      val r = RegisteredReachable
      r
    case software.amazon.awssdk.services.iotwireless.model.DeviceState.REGISTERED_UNREACHABLE =>
      val r = RegisteredUnreachable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.DeviceState {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DeviceState =
      software.amazon.awssdk.services.iotwireless.model.DeviceState.UNKNOWN_TO_SDK_VERSION
  }
  case object Provisioned extends zio.aws.iotwireless.model.DeviceState {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DeviceState =
      software.amazon.awssdk.services.iotwireless.model.DeviceState.PROVISIONED
  }
  case object RegisteredNotSeen extends zio.aws.iotwireless.model.DeviceState {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DeviceState =
      software.amazon.awssdk.services.iotwireless.model.DeviceState.REGISTERED_NOT_SEEN
  }
  case object RegisteredReachable
      extends zio.aws.iotwireless.model.DeviceState {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DeviceState =
      software.amazon.awssdk.services.iotwireless.model.DeviceState.REGISTERED_REACHABLE
  }
  case object RegisteredUnreachable
      extends zio.aws.iotwireless.model.DeviceState {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DeviceState =
      software.amazon.awssdk.services.iotwireless.model.DeviceState.REGISTERED_UNREACHABLE
  }
}
