package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessDeviceId,
  WirelessDeviceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWirelessDeviceResponse(
    arn: Optional[WirelessDeviceArn] = Optional.Absent,
    id: Optional[WirelessDeviceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse = {
    import CreateWirelessDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse
      .builder()
      .optionallyWith(
        arn.map(value => WirelessDeviceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => WirelessDeviceId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateWirelessDeviceResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateWirelessDeviceResponse.wrap(buildAwsValue())
}
object CreateWirelessDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateWirelessDeviceResponse =
      zio.aws.iotwireless.model.CreateWirelessDeviceResponse(
        arn.map(value => value),
        id.map(value => value)
      )
    def arn: Optional[WirelessDeviceArn]
    def id: Optional[WirelessDeviceId]
    def getArn: ZIO[Any, AwsError, WirelessDeviceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, WirelessDeviceId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse
  ) extends zio.aws.iotwireless.model.CreateWirelessDeviceResponse.ReadOnly {
    override val arn: Optional[WirelessDeviceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceArn(value)
      )
    override val id: Optional[WirelessDeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceResponse
  ): zio.aws.iotwireless.model.CreateWirelessDeviceResponse.ReadOnly =
    new Wrapper(impl)
}
