package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait WirelessDeviceType {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType
}
object WirelessDeviceType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType
  ): zio.aws.iotwireless.model.WirelessDeviceType = value match {
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType.SIDEWALK =>
      val r = Sidewalk
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType.LO_RA_WAN =>
      val r = LoRaWAN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.WirelessDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType.UNKNOWN_TO_SDK_VERSION
  }
  case object Sidewalk extends zio.aws.iotwireless.model.WirelessDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType.SIDEWALK
  }
  case object LoRaWAN extends zio.aws.iotwireless.model.WirelessDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType.LO_RA_WAN
  }
}
