package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  Description,
  WirelessDeviceName,
  DestinationName,
  WirelessDeviceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateWirelessDeviceRequest(
    id: WirelessDeviceId,
    destinationName: Optional[DestinationName] = Optional.Absent,
    name: Optional[WirelessDeviceName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANUpdateDevice] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest = {
    import UpdateWirelessDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest
      .builder()
      .id(WirelessDeviceId.unwrap(id): java.lang.String)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(
        name.map(value => WirelessDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateWirelessDeviceRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateWirelessDeviceRequest.wrap(buildAwsValue())
}
object UpdateWirelessDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateWirelessDeviceRequest =
      zio.aws.iotwireless.model.UpdateWirelessDeviceRequest(
        id,
        destinationName.map(value => value),
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable)
      )
    def id: WirelessDeviceId
    def destinationName: Optional[DestinationName]
    def name: Optional[WirelessDeviceName]
    def description: Optional[Description]
    def loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly]
    def getId: ZIO[Any, Nothing, WirelessDeviceId] = ZIO.succeed(id)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getName: ZIO[Any, AwsError, WirelessDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest
  ) extends zio.aws.iotwireless.model.UpdateWirelessDeviceRequest.ReadOnly {
    override val id: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId(impl.id())
    override val destinationName: Optional[DestinationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationName())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DestinationName(value)
        )
    override val name: Optional[WirelessDeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceName(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANUpdateDevice.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest
  ): zio.aws.iotwireless.model.UpdateWirelessDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
