package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  PositionCoordinateValue,
  PositionResourceIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdatePositionRequest(
    resourceIdentifier: PositionResourceIdentifier,
    resourceType: zio.aws.iotwireless.model.PositionResourceType,
    position: Iterable[PositionCoordinateValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdatePositionRequest = {
    import UpdatePositionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdatePositionRequest
      .builder()
      .resourceIdentifier(
        PositionResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .resourceType(resourceType.unwrap)
      .position(position.map { item =>
        PositionCoordinateValue.unwrap(item): java.lang.Float
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.UpdatePositionRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdatePositionRequest.wrap(buildAwsValue())
}
object UpdatePositionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdatePositionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdatePositionRequest =
      zio.aws.iotwireless.model
        .UpdatePositionRequest(resourceIdentifier, resourceType, position)
    def resourceIdentifier: PositionResourceIdentifier
    def resourceType: zio.aws.iotwireless.model.PositionResourceType
    def position: List[PositionCoordinateValue]
    def getResourceIdentifier: ZIO[Any, Nothing, PositionResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.PositionResourceType] =
      ZIO.succeed(resourceType)
    def getPosition: ZIO[Any, Nothing, List[PositionCoordinateValue]] =
      ZIO.succeed(position)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdatePositionRequest
  ) extends zio.aws.iotwireless.model.UpdatePositionRequest.ReadOnly {
    override val resourceIdentifier: PositionResourceIdentifier =
      zio.aws.iotwireless.model.primitives
        .PositionResourceIdentifier(impl.resourceIdentifier())
    override val resourceType: zio.aws.iotwireless.model.PositionResourceType =
      zio.aws.iotwireless.model.PositionResourceType.wrap(impl.resourceType())
    override val position: List[PositionCoordinateValue] = impl
      .position()
      .asScala
      .map { item =>
        zio.aws.iotwireless.model.primitives.PositionCoordinateValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdatePositionRequest
  ): zio.aws.iotwireless.model.UpdatePositionRequest.ReadOnly = new Wrapper(
    impl
  )
}
