package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFPorts(
    positioning: Optional[zio.aws.iotwireless.model.Positioning] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateFPorts = {
    import UpdateFPorts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateFPorts
      .builder()
      .optionallyWith(positioning.map(value => value.buildAwsValue()))(
        _.positioning
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.UpdateFPorts.ReadOnly =
    zio.aws.iotwireless.model.UpdateFPorts.wrap(buildAwsValue())
}
object UpdateFPorts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateFPorts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateFPorts =
      zio.aws.iotwireless.model
        .UpdateFPorts(positioning.map(value => value.asEditable))
    def positioning: Optional[zio.aws.iotwireless.model.Positioning.ReadOnly]
    def getPositioning
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.Positioning.ReadOnly] =
      AwsError.unwrapOptionField("positioning", positioning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateFPorts
  ) extends zio.aws.iotwireless.model.UpdateFPorts.ReadOnly {
    override val positioning
        : Optional[zio.aws.iotwireless.model.Positioning.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positioning())
        .map(value => zio.aws.iotwireless.model.Positioning.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateFPorts
  ): zio.aws.iotwireless.model.UpdateFPorts.ReadOnly = new Wrapper(impl)
}
