package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkResourceTypeEventConfiguration(
    wirelessDeviceEventTopic: Optional[
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkResourceTypeEventConfiguration = {
    import SidewalkResourceTypeEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkResourceTypeEventConfiguration
      .builder()
      .optionallyWith(wirelessDeviceEventTopic.map(value => value.unwrap))(
        _.wirelessDeviceEventTopic
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration
      .wrap(buildAwsValue())
}
object SidewalkResourceTypeEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkResourceTypeEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration =
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration(
        wirelessDeviceEventTopic.map(value => value)
      )
    def wirelessDeviceEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus]
    def getWirelessDeviceEventTopic: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = AwsError.unwrapOptionField(
      "wirelessDeviceEventTopic",
      wirelessDeviceEventTopic
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkResourceTypeEventConfiguration
  ) extends zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly {
    override val wirelessDeviceEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDeviceEventTopic())
        .map(value =>
          zio.aws.iotwireless.model.EventNotificationTopicStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkResourceTypeEventConfiguration
  ): zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
