package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SemtechGnssDetail(
    provider: Optional[zio.aws.iotwireless.model.PositionSolverProvider] =
      Optional.Absent,
    `type`: Optional[zio.aws.iotwireless.model.PositionSolverType] =
      Optional.Absent,
    status: Optional[zio.aws.iotwireless.model.PositionConfigurationStatus] =
      Optional.Absent,
    fec: Optional[zio.aws.iotwireless.model.PositionConfigurationFec] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SemtechGnssDetail = {
    import SemtechGnssDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SemtechGnssDetail
      .builder()
      .optionallyWith(provider.map(value => value.unwrap))(_.provider)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(fec.map(value => value.unwrap))(_.fec)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SemtechGnssDetail.ReadOnly =
    zio.aws.iotwireless.model.SemtechGnssDetail.wrap(buildAwsValue())
}
object SemtechGnssDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SemtechGnssDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SemtechGnssDetail =
      zio.aws.iotwireless.model.SemtechGnssDetail(
        provider.map(value => value),
        `type`.map(value => value),
        status.map(value => value),
        fec.map(value => value)
      )
    def provider: Optional[zio.aws.iotwireless.model.PositionSolverProvider]
    def `type`: Optional[zio.aws.iotwireless.model.PositionSolverType]
    def status: Optional[zio.aws.iotwireless.model.PositionConfigurationStatus]
    def fec: Optional[zio.aws.iotwireless.model.PositionConfigurationFec]
    def getProvider
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.PositionSolverProvider] =
      AwsError.unwrapOptionField("provider", provider)
    def getType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.PositionSolverType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.PositionConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFec: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.PositionConfigurationFec
    ] = AwsError.unwrapOptionField("fec", fec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SemtechGnssDetail
  ) extends zio.aws.iotwireless.model.SemtechGnssDetail.ReadOnly {
    override val provider
        : Optional[zio.aws.iotwireless.model.PositionSolverProvider] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provider())
        .map(value =>
          zio.aws.iotwireless.model.PositionSolverProvider.wrap(value)
        )
    override val `type`
        : Optional[zio.aws.iotwireless.model.PositionSolverType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.iotwireless.model.PositionSolverType.wrap(value))
    override val status
        : Optional[zio.aws.iotwireless.model.PositionConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iotwireless.model.PositionConfigurationStatus.wrap(value)
        )
    override val fec
        : Optional[zio.aws.iotwireless.model.PositionConfigurationFec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fec())
        .map(value =>
          zio.aws.iotwireless.model.PositionConfigurationFec.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SemtechGnssDetail
  ): zio.aws.iotwireless.model.SemtechGnssDetail.ReadOnly = new Wrapper(impl)
}
