package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SemtechGnssConfiguration(
    status: zio.aws.iotwireless.model.PositionConfigurationStatus,
    fec: zio.aws.iotwireless.model.PositionConfigurationFec
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SemtechGnssConfiguration = {
    import SemtechGnssConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SemtechGnssConfiguration
      .builder()
      .status(status.unwrap)
      .fec(fec.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SemtechGnssConfiguration.ReadOnly =
    zio.aws.iotwireless.model.SemtechGnssConfiguration.wrap(buildAwsValue())
}
object SemtechGnssConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SemtechGnssConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SemtechGnssConfiguration =
      zio.aws.iotwireless.model.SemtechGnssConfiguration(status, fec)
    def status: zio.aws.iotwireless.model.PositionConfigurationStatus
    def fec: zio.aws.iotwireless.model.PositionConfigurationFec
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.PositionConfigurationStatus
    ] = ZIO.succeed(status)
    def getFec: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.PositionConfigurationFec
    ] = ZIO.succeed(fec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SemtechGnssConfiguration
  ) extends zio.aws.iotwireless.model.SemtechGnssConfiguration.ReadOnly {
    override val status: zio.aws.iotwireless.model.PositionConfigurationStatus =
      zio.aws.iotwireless.model.PositionConfigurationStatus.wrap(impl.status())
    override val fec: zio.aws.iotwireless.model.PositionConfigurationFec =
      zio.aws.iotwireless.model.PositionConfigurationFec.wrap(impl.fec())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SemtechGnssConfiguration
  ): zio.aws.iotwireless.model.SemtechGnssConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
