package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  DestinationName,
  PositionResourceIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutPositionConfigurationRequest(
    resourceIdentifier: PositionResourceIdentifier,
    resourceType: zio.aws.iotwireless.model.PositionResourceType,
    solvers: Optional[zio.aws.iotwireless.model.PositionSolverConfigurations] =
      Optional.Absent,
    destination: Optional[DestinationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationRequest = {
    import PutPositionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationRequest
      .builder()
      .resourceIdentifier(
        PositionResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .resourceType(resourceType.unwrap)
      .optionallyWith(solvers.map(value => value.buildAwsValue()))(_.solvers)
      .optionallyWith(
        destination.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destination)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.PutPositionConfigurationRequest.ReadOnly =
    zio.aws.iotwireless.model.PutPositionConfigurationRequest
      .wrap(buildAwsValue())
}
object PutPositionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.PutPositionConfigurationRequest =
      zio.aws.iotwireless.model.PutPositionConfigurationRequest(
        resourceIdentifier,
        resourceType,
        solvers.map(value => value.asEditable),
        destination.map(value => value)
      )
    def resourceIdentifier: PositionResourceIdentifier
    def resourceType: zio.aws.iotwireless.model.PositionResourceType
    def solvers: Optional[
      zio.aws.iotwireless.model.PositionSolverConfigurations.ReadOnly
    ]
    def destination: Optional[DestinationName]
    def getResourceIdentifier: ZIO[Any, Nothing, PositionResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.PositionResourceType] =
      ZIO.succeed(resourceType)
    def getSolvers: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.PositionSolverConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("solvers", solvers)
    def getDestination: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationRequest
  ) extends zio.aws.iotwireless.model.PutPositionConfigurationRequest.ReadOnly {
    override val resourceIdentifier: PositionResourceIdentifier =
      zio.aws.iotwireless.model.primitives
        .PositionResourceIdentifier(impl.resourceIdentifier())
    override val resourceType: zio.aws.iotwireless.model.PositionResourceType =
      zio.aws.iotwireless.model.PositionResourceType.wrap(impl.resourceType())
    override val solvers: Optional[
      zio.aws.iotwireless.model.PositionSolverConfigurations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.solvers())
      .map(value =>
        zio.aws.iotwireless.model.PositionSolverConfigurations.wrap(value)
      )
    override val destination: Optional[DestinationName] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.PutPositionConfigurationRequest
  ): zio.aws.iotwireless.model.PutPositionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
