package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProximityResourceTypeEventConfiguration(
    sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ProximityResourceTypeEventConfiguration = {
    import ProximityResourceTypeEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ProximityResourceTypeEventConfiguration
      .builder()
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration
      .wrap(buildAwsValue())
}
object ProximityResourceTypeEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ProximityResourceTypeEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration =
      zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration(
        sidewalk.map(value => value.asEditable)
      )
    def sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly
    ]
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ProximityResourceTypeEventConfiguration
  ) extends zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration.ReadOnly {
    override val sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ProximityResourceTypeEventConfiguration
  ): zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
