package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait PositionSolverType {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.PositionSolverType
}
object PositionSolverType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.PositionSolverType
  ): zio.aws.iotwireless.model.PositionSolverType = value match {
    case software.amazon.awssdk.services.iotwireless.model.PositionSolverType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.PositionSolverType.GNSS =>
      val r = GNSS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.PositionSolverType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.PositionSolverType =
      software.amazon.awssdk.services.iotwireless.model.PositionSolverType.UNKNOWN_TO_SDK_VERSION
  }
  case object GNSS extends zio.aws.iotwireless.model.PositionSolverType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.PositionSolverType =
      software.amazon.awssdk.services.iotwireless.model.PositionSolverType.GNSS
  }
}
