package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait PositionSolverProvider {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.PositionSolverProvider
}
object PositionSolverProvider {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.PositionSolverProvider
  ): zio.aws.iotwireless.model.PositionSolverProvider = value match {
    case software.amazon.awssdk.services.iotwireless.model.PositionSolverProvider.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.PositionSolverProvider.SEMTECH =>
      val r = Semtech
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.PositionSolverProvider {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.PositionSolverProvider =
      software.amazon.awssdk.services.iotwireless.model.PositionSolverProvider.UNKNOWN_TO_SDK_VERSION
  }
  case object Semtech extends zio.aws.iotwireless.model.PositionSolverProvider {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.PositionSolverProvider =
      software.amazon.awssdk.services.iotwireless.model.PositionSolverProvider.SEMTECH
  }
}
