package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PositionSolverDetails(
    semtechGnss: Optional[zio.aws.iotwireless.model.SemtechGnssDetail] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.PositionSolverDetails = {
    import PositionSolverDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.PositionSolverDetails
      .builder()
      .optionallyWith(semtechGnss.map(value => value.buildAwsValue()))(
        _.semtechGnss
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.PositionSolverDetails.ReadOnly =
    zio.aws.iotwireless.model.PositionSolverDetails.wrap(buildAwsValue())
}
object PositionSolverDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.PositionSolverDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.PositionSolverDetails =
      zio.aws.iotwireless.model
        .PositionSolverDetails(semtechGnss.map(value => value.asEditable))
    def semtechGnss
        : Optional[zio.aws.iotwireless.model.SemtechGnssDetail.ReadOnly]
    def getSemtechGnss: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SemtechGnssDetail.ReadOnly
    ] = AwsError.unwrapOptionField("semtechGnss", semtechGnss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.PositionSolverDetails
  ) extends zio.aws.iotwireless.model.PositionSolverDetails.ReadOnly {
    override val semtechGnss
        : Optional[zio.aws.iotwireless.model.SemtechGnssDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.semtechGnss())
        .map(value => zio.aws.iotwireless.model.SemtechGnssDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.PositionSolverDetails
  ): zio.aws.iotwireless.model.PositionSolverDetails.ReadOnly = new Wrapper(
    impl
  )
}
