package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PositionSolverConfigurations(
    semtechGnss: Optional[zio.aws.iotwireless.model.SemtechGnssConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.PositionSolverConfigurations = {
    import PositionSolverConfigurations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.PositionSolverConfigurations
      .builder()
      .optionallyWith(semtechGnss.map(value => value.buildAwsValue()))(
        _.semtechGnss
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.PositionSolverConfigurations.ReadOnly =
    zio.aws.iotwireless.model.PositionSolverConfigurations.wrap(buildAwsValue())
}
object PositionSolverConfigurations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.PositionSolverConfigurations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.PositionSolverConfigurations =
      zio.aws.iotwireless.model.PositionSolverConfigurations(
        semtechGnss.map(value => value.asEditable)
      )
    def semtechGnss
        : Optional[zio.aws.iotwireless.model.SemtechGnssConfiguration.ReadOnly]
    def getSemtechGnss: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SemtechGnssConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("semtechGnss", semtechGnss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.PositionSolverConfigurations
  ) extends zio.aws.iotwireless.model.PositionSolverConfigurations.ReadOnly {
    override val semtechGnss: Optional[
      zio.aws.iotwireless.model.SemtechGnssConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.semtechGnss())
      .map(value =>
        zio.aws.iotwireless.model.SemtechGnssConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.PositionSolverConfigurations
  ): zio.aws.iotwireless.model.PositionSolverConfigurations.ReadOnly =
    new Wrapper(impl)
}
