package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  DestinationName,
  PositionResourceIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PositionConfigurationItem(
    resourceIdentifier: Optional[PositionResourceIdentifier] = Optional.Absent,
    resourceType: Optional[zio.aws.iotwireless.model.PositionResourceType] =
      Optional.Absent,
    solvers: Optional[zio.aws.iotwireless.model.PositionSolverDetails] =
      Optional.Absent,
    destination: Optional[DestinationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.PositionConfigurationItem = {
    import PositionConfigurationItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.PositionConfigurationItem
      .builder()
      .optionallyWith(
        resourceIdentifier.map(value =>
          PositionResourceIdentifier.unwrap(value): java.lang.String
        )
      )(_.resourceIdentifier)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(solvers.map(value => value.buildAwsValue()))(_.solvers)
      .optionallyWith(
        destination.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destination)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.PositionConfigurationItem.ReadOnly =
    zio.aws.iotwireless.model.PositionConfigurationItem.wrap(buildAwsValue())
}
object PositionConfigurationItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.PositionConfigurationItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.PositionConfigurationItem =
      zio.aws.iotwireless.model.PositionConfigurationItem(
        resourceIdentifier.map(value => value),
        resourceType.map(value => value),
        solvers.map(value => value.asEditable),
        destination.map(value => value)
      )
    def resourceIdentifier: Optional[PositionResourceIdentifier]
    def resourceType: Optional[zio.aws.iotwireless.model.PositionResourceType]
    def solvers
        : Optional[zio.aws.iotwireless.model.PositionSolverDetails.ReadOnly]
    def destination: Optional[DestinationName]
    def getResourceIdentifier: ZIO[Any, AwsError, PositionResourceIdentifier] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.PositionResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSolvers: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.PositionSolverDetails.ReadOnly
    ] = AwsError.unwrapOptionField("solvers", solvers)
    def getDestination: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.PositionConfigurationItem
  ) extends zio.aws.iotwireless.model.PositionConfigurationItem.ReadOnly {
    override val resourceIdentifier: Optional[PositionResourceIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdentifier())
        .map(value =>
          zio.aws.iotwireless.model.primitives.PositionResourceIdentifier(value)
        )
    override val resourceType
        : Optional[zio.aws.iotwireless.model.PositionResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.iotwireless.model.PositionResourceType.wrap(value)
        )
    override val solvers
        : Optional[zio.aws.iotwireless.model.PositionSolverDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solvers())
        .map(value =>
          zio.aws.iotwireless.model.PositionSolverDetails.wrap(value)
        )
    override val destination: Optional[DestinationName] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.PositionConfigurationItem
  ): zio.aws.iotwireless.model.PositionConfigurationItem.ReadOnly = new Wrapper(
    impl
  )
}
