package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{DrMaxBox, DrMinBox, AddGwMetadata}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoRaWANServiceProfile(
    addGwMetadata: Optional[AddGwMetadata] = Optional.Absent,
    drMin: Optional[DrMinBox] = Optional.Absent,
    drMax: Optional[DrMaxBox] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile = {
    import LoRaWANServiceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
      .builder()
      .optionallyWith(
        addGwMetadata.map(value =>
          AddGwMetadata.unwrap(value): java.lang.Boolean
        )
      )(_.addGwMetadata)
      .optionallyWith(drMin.map(value => DrMinBox.unwrap(value): Integer))(
        _.drMin
      )
      .optionallyWith(drMax.map(value => DrMaxBox.unwrap(value): Integer))(
        _.drMax
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANServiceProfile.wrap(buildAwsValue())
}
object LoRaWANServiceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANServiceProfile =
      zio.aws.iotwireless.model.LoRaWANServiceProfile(
        addGwMetadata.map(value => value),
        drMin.map(value => value),
        drMax.map(value => value)
      )
    def addGwMetadata: Optional[AddGwMetadata]
    def drMin: Optional[DrMinBox]
    def drMax: Optional[DrMaxBox]
    def getAddGwMetadata: ZIO[Any, AwsError, AddGwMetadata] =
      AwsError.unwrapOptionField("addGwMetadata", addGwMetadata)
    def getDrMin: ZIO[Any, AwsError, DrMinBox] =
      AwsError.unwrapOptionField("drMin", drMin)
    def getDrMax: ZIO[Any, AwsError, DrMaxBox] =
      AwsError.unwrapOptionField("drMax", drMax)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
  ) extends zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly {
    override val addGwMetadata: Optional[AddGwMetadata] = zio.aws.core.internal
      .optionalFromNullable(impl.addGwMetadata())
      .map(value => zio.aws.iotwireless.model.primitives.AddGwMetadata(value))
    override val drMin: Optional[DrMinBox] = zio.aws.core.internal
      .optionalFromNullable(impl.drMin())
      .map(value => zio.aws.iotwireless.model.primitives.DrMinBox(value))
    override val drMax: Optional[DrMaxBox] = zio.aws.core.internal
      .optionalFromNullable(impl.drMax())
      .map(value => zio.aws.iotwireless.model.primitives.DrMaxBox(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANServiceProfile
  ): zio.aws.iotwireless.model.LoRaWANServiceProfile.ReadOnly = new Wrapper(
    impl
  )
}
