package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  NumberOfDevicesInGroup,
  NumberOfDevicesRequested
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoRaWANMulticastGet(
    rfRegion: Optional[zio.aws.iotwireless.model.SupportedRfRegion] =
      Optional.Absent,
    dlClass: Optional[zio.aws.iotwireless.model.DlClass] = Optional.Absent,
    numberOfDevicesRequested: Optional[NumberOfDevicesRequested] =
      Optional.Absent,
    numberOfDevicesInGroup: Optional[NumberOfDevicesInGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastGet = {
    import LoRaWANMulticastGet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastGet
      .builder()
      .optionallyWith(rfRegion.map(value => value.unwrap))(_.rfRegion)
      .optionallyWith(dlClass.map(value => value.unwrap))(_.dlClass)
      .optionallyWith(
        numberOfDevicesRequested.map(value =>
          NumberOfDevicesRequested.unwrap(value): Integer
        )
      )(_.numberOfDevicesRequested)
      .optionallyWith(
        numberOfDevicesInGroup.map(value =>
          NumberOfDevicesInGroup.unwrap(value): Integer
        )
      )(_.numberOfDevicesInGroup)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANMulticastGet.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANMulticastGet.wrap(buildAwsValue())
}
object LoRaWANMulticastGet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastGet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANMulticastGet =
      zio.aws.iotwireless.model.LoRaWANMulticastGet(
        rfRegion.map(value => value),
        dlClass.map(value => value),
        numberOfDevicesRequested.map(value => value),
        numberOfDevicesInGroup.map(value => value)
      )
    def rfRegion: Optional[zio.aws.iotwireless.model.SupportedRfRegion]
    def dlClass: Optional[zio.aws.iotwireless.model.DlClass]
    def numberOfDevicesRequested: Optional[NumberOfDevicesRequested]
    def numberOfDevicesInGroup: Optional[NumberOfDevicesInGroup]
    def getRfRegion
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.SupportedRfRegion] =
      AwsError.unwrapOptionField("rfRegion", rfRegion)
    def getDlClass: ZIO[Any, AwsError, zio.aws.iotwireless.model.DlClass] =
      AwsError.unwrapOptionField("dlClass", dlClass)
    def getNumberOfDevicesRequested
        : ZIO[Any, AwsError, NumberOfDevicesRequested] = AwsError
      .unwrapOptionField("numberOfDevicesRequested", numberOfDevicesRequested)
    def getNumberOfDevicesInGroup: ZIO[Any, AwsError, NumberOfDevicesInGroup] =
      AwsError.unwrapOptionField(
        "numberOfDevicesInGroup",
        numberOfDevicesInGroup
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastGet
  ) extends zio.aws.iotwireless.model.LoRaWANMulticastGet.ReadOnly {
    override val rfRegion
        : Optional[zio.aws.iotwireless.model.SupportedRfRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rfRegion())
        .map(value => zio.aws.iotwireless.model.SupportedRfRegion.wrap(value))
    override val dlClass: Optional[zio.aws.iotwireless.model.DlClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dlClass())
        .map(value => zio.aws.iotwireless.model.DlClass.wrap(value))
    override val numberOfDevicesRequested: Optional[NumberOfDevicesRequested] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfDevicesRequested())
        .map(value =>
          zio.aws.iotwireless.model.primitives.NumberOfDevicesRequested(value)
        )
    override val numberOfDevicesInGroup: Optional[NumberOfDevicesInGroup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfDevicesInGroup())
        .map(value =>
          zio.aws.iotwireless.model.primitives.NumberOfDevicesInGroup(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastGet
  ): zio.aws.iotwireless.model.LoRaWANMulticastGet.ReadOnly = new Wrapper(impl)
}
