package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPositionConfigurationsResponse(
    positionConfigurationList: Optional[
      Iterable[zio.aws.iotwireless.model.PositionConfigurationItem]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse = {
    import ListPositionConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse
      .builder()
      .optionallyWith(
        positionConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.positionConfigurationList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListPositionConfigurationsResponse.ReadOnly =
    zio.aws.iotwireless.model.ListPositionConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListPositionConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListPositionConfigurationsResponse =
      zio.aws.iotwireless.model.ListPositionConfigurationsResponse(
        positionConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def positionConfigurationList: Optional[
      List[zio.aws.iotwireless.model.PositionConfigurationItem.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getPositionConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.PositionConfigurationItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "positionConfigurationList",
      positionConfigurationList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse
  ) extends zio.aws.iotwireless.model.ListPositionConfigurationsResponse.ReadOnly {
    override val positionConfigurationList: Optional[
      List[zio.aws.iotwireless.model.PositionConfigurationItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.positionConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.PositionConfigurationItem.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse
  ): zio.aws.iotwireless.model.ListPositionConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
