package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPositionConfigurationsRequest(
    resourceType: Optional[zio.aws.iotwireless.model.PositionResourceType] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest = {
    import ListPositionConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListPositionConfigurationsRequest.ReadOnly =
    zio.aws.iotwireless.model.ListPositionConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListPositionConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListPositionConfigurationsRequest =
      zio.aws.iotwireless.model.ListPositionConfigurationsRequest(
        resourceType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceType: Optional[zio.aws.iotwireless.model.PositionResourceType]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.PositionResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest
  ) extends zio.aws.iotwireless.model.ListPositionConfigurationsRequest.ReadOnly {
    override val resourceType
        : Optional[zio.aws.iotwireless.model.PositionResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.iotwireless.model.PositionResourceType.wrap(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest
  ): zio.aws.iotwireless.model.ListPositionConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
