package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JoinEventConfiguration(
    loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations
    ] = Optional.Absent,
    wirelessDeviceIdEventTopic: Optional[
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.JoinEventConfiguration = {
    import JoinEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.JoinEventConfiguration
      .builder()
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(wirelessDeviceIdEventTopic.map(value => value.unwrap))(
        _.wirelessDeviceIdEventTopic
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.JoinEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.JoinEventConfiguration.wrap(buildAwsValue())
}
object JoinEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.JoinEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.JoinEventConfiguration =
      zio.aws.iotwireless.model.JoinEventConfiguration(
        loRaWAN.map(value => value.asEditable),
        wirelessDeviceIdEventTopic.map(value => value)
      )
    def loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations.ReadOnly
    ]
    def wirelessDeviceIdEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus]
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getWirelessDeviceIdEventTopic: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = AwsError.unwrapOptionField(
      "wirelessDeviceIdEventTopic",
      wirelessDeviceIdEventTopic
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.JoinEventConfiguration
  ) extends zio.aws.iotwireless.model.JoinEventConfiguration.ReadOnly {
    override val loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loRaWAN())
      .map(value =>
        zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations
          .wrap(value)
      )
    override val wirelessDeviceIdEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDeviceIdEventTopic())
        .map(value =>
          zio.aws.iotwireless.model.EventNotificationTopicStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.JoinEventConfiguration
  ): zio.aws.iotwireless.model.JoinEventConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
