package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayFirmwareInformationResponse(
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse = {
    import GetWirelessGatewayFirmwareInformationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse
      .builder()
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse
      .wrap(buildAwsValue())
}
object GetWirelessGatewayFirmwareInformationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse =
      zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse(
        loRaWAN.map(value => value.asEditable)
      )
    def loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.ReadOnly
    ]
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse.ReadOnly {
    override val loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loRaWAN())
      .map(value =>
        zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse
  ): zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse.ReadOnly =
    new Wrapper(impl)
}
