package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ISODateTimeString,
  PositionSolverVersion,
  PositionCoordinateValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPositionResponse(
    position: Optional[Iterable[PositionCoordinateValue]] = Optional.Absent,
    accuracy: Optional[zio.aws.iotwireless.model.Accuracy] = Optional.Absent,
    solverType: Optional[zio.aws.iotwireless.model.PositionSolverType] =
      Optional.Absent,
    solverProvider: Optional[zio.aws.iotwireless.model.PositionSolverProvider] =
      Optional.Absent,
    solverVersion: Optional[PositionSolverVersion] = Optional.Absent,
    timestamp: Optional[ISODateTimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetPositionResponse = {
    import GetPositionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetPositionResponse
      .builder()
      .optionallyWith(
        position.map(value =>
          value.map { item =>
            PositionCoordinateValue.unwrap(item): java.lang.Float
          }.asJavaCollection
        )
      )(_.position)
      .optionallyWith(accuracy.map(value => value.buildAwsValue()))(_.accuracy)
      .optionallyWith(solverType.map(value => value.unwrap))(_.solverType)
      .optionallyWith(solverProvider.map(value => value.unwrap))(
        _.solverProvider
      )
      .optionallyWith(
        solverVersion.map(value =>
          PositionSolverVersion.unwrap(value): java.lang.String
        )
      )(_.solverVersion)
      .optionallyWith(
        timestamp.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.timestamp)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetPositionResponse.ReadOnly =
    zio.aws.iotwireless.model.GetPositionResponse.wrap(buildAwsValue())
}
object GetPositionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetPositionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetPositionResponse =
      zio.aws.iotwireless.model.GetPositionResponse(
        position.map(value => value),
        accuracy.map(value => value.asEditable),
        solverType.map(value => value),
        solverProvider.map(value => value),
        solverVersion.map(value => value),
        timestamp.map(value => value)
      )
    def position: Optional[List[PositionCoordinateValue]]
    def accuracy: Optional[zio.aws.iotwireless.model.Accuracy.ReadOnly]
    def solverType: Optional[zio.aws.iotwireless.model.PositionSolverType]
    def solverProvider
        : Optional[zio.aws.iotwireless.model.PositionSolverProvider]
    def solverVersion: Optional[PositionSolverVersion]
    def timestamp: Optional[ISODateTimeString]
    def getPosition: ZIO[Any, AwsError, List[PositionCoordinateValue]] =
      AwsError.unwrapOptionField("position", position)
    def getAccuracy
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.Accuracy.ReadOnly] =
      AwsError.unwrapOptionField("accuracy", accuracy)
    def getSolverType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.PositionSolverType] =
      AwsError.unwrapOptionField("solverType", solverType)
    def getSolverProvider
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.PositionSolverProvider] =
      AwsError.unwrapOptionField("solverProvider", solverProvider)
    def getSolverVersion: ZIO[Any, AwsError, PositionSolverVersion] =
      AwsError.unwrapOptionField("solverVersion", solverVersion)
    def getTimestamp: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPositionResponse
  ) extends zio.aws.iotwireless.model.GetPositionResponse.ReadOnly {
    override val position: Optional[List[PositionCoordinateValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.PositionCoordinateValue(item)
          }.toList
        )
    override val accuracy
        : Optional[zio.aws.iotwireless.model.Accuracy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accuracy())
        .map(value => zio.aws.iotwireless.model.Accuracy.wrap(value))
    override val solverType
        : Optional[zio.aws.iotwireless.model.PositionSolverType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solverType())
        .map(value => zio.aws.iotwireless.model.PositionSolverType.wrap(value))
    override val solverProvider
        : Optional[zio.aws.iotwireless.model.PositionSolverProvider] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solverProvider())
        .map(value =>
          zio.aws.iotwireless.model.PositionSolverProvider.wrap(value)
        )
    override val solverVersion: Optional[PositionSolverVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solverVersion())
        .map(value =>
          zio.aws.iotwireless.model.primitives.PositionSolverVersion(value)
        )
    override val timestamp: Optional[ISODateTimeString] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPositionResponse
  ): zio.aws.iotwireless.model.GetPositionResponse.ReadOnly = new Wrapper(impl)
}
