package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.DestinationName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPositionConfigurationResponse(
    solvers: Optional[zio.aws.iotwireless.model.PositionSolverDetails] =
      Optional.Absent,
    destination: Optional[DestinationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationResponse = {
    import GetPositionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationResponse
      .builder()
      .optionallyWith(solvers.map(value => value.buildAwsValue()))(_.solvers)
      .optionallyWith(
        destination.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destination)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetPositionConfigurationResponse.ReadOnly =
    zio.aws.iotwireless.model.GetPositionConfigurationResponse
      .wrap(buildAwsValue())
}
object GetPositionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetPositionConfigurationResponse =
      zio.aws.iotwireless.model.GetPositionConfigurationResponse(
        solvers.map(value => value.asEditable),
        destination.map(value => value)
      )
    def solvers
        : Optional[zio.aws.iotwireless.model.PositionSolverDetails.ReadOnly]
    def destination: Optional[DestinationName]
    def getSolvers: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.PositionSolverDetails.ReadOnly
    ] = AwsError.unwrapOptionField("solvers", solvers)
    def getDestination: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationResponse
  ) extends zio.aws.iotwireless.model.GetPositionConfigurationResponse.ReadOnly {
    override val solvers
        : Optional[zio.aws.iotwireless.model.PositionSolverDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solvers())
        .map(value =>
          zio.aws.iotwireless.model.PositionSolverDetails.wrap(value)
        )
    override val destination: Optional[DestinationName] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationResponse
  ): zio.aws.iotwireless.model.GetPositionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
