package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.PositionResourceIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPositionConfigurationRequest(
    resourceIdentifier: PositionResourceIdentifier,
    resourceType: zio.aws.iotwireless.model.PositionResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationRequest = {
    import GetPositionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationRequest
      .builder()
      .resourceIdentifier(
        PositionResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .resourceType(resourceType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetPositionConfigurationRequest.ReadOnly =
    zio.aws.iotwireless.model.GetPositionConfigurationRequest
      .wrap(buildAwsValue())
}
object GetPositionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetPositionConfigurationRequest =
      zio.aws.iotwireless.model
        .GetPositionConfigurationRequest(resourceIdentifier, resourceType)
    def resourceIdentifier: PositionResourceIdentifier
    def resourceType: zio.aws.iotwireless.model.PositionResourceType
    def getResourceIdentifier: ZIO[Any, Nothing, PositionResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.PositionResourceType] =
      ZIO.succeed(resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationRequest
  ) extends zio.aws.iotwireless.model.GetPositionConfigurationRequest.ReadOnly {
    override val resourceIdentifier: PositionResourceIdentifier =
      zio.aws.iotwireless.model.primitives
        .PositionResourceIdentifier(impl.resourceIdentifier())
    override val resourceType: zio.aws.iotwireless.model.PositionResourceType =
      zio.aws.iotwireless.model.PositionResourceType.wrap(impl.resourceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPositionConfigurationRequest
  ): zio.aws.iotwireless.model.GetPositionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
