package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.MulticastGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMulticastGroupRequest(id: MulticastGroupId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupRequest = {
    import DeleteMulticastGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeleteMulticastGroupRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteMulticastGroupRequest.wrap(buildAwsValue())
}
object DeleteMulticastGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeleteMulticastGroupRequest =
      zio.aws.iotwireless.model.DeleteMulticastGroupRequest(id)
    def id: MulticastGroupId
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupRequest
  ) extends zio.aws.iotwireless.model.DeleteMulticastGroupRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteMulticastGroupRequest
  ): zio.aws.iotwireless.model.DeleteMulticastGroupRequest.ReadOnly =
    new Wrapper(impl)
}
