package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  FirmwareUpdateRole,
  ClientRequestToken,
  FirmwareUpdateImage,
  FuotaTaskName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFuotaTaskRequest(
    name: Optional[FuotaTaskName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask] =
      Optional.Absent,
    firmwareUpdateImage: FirmwareUpdateImage,
    firmwareUpdateRole: FirmwareUpdateRole,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest = {
    import CreateFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
      .builder()
      .optionallyWith(
        name.map(value => FuotaTaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .firmwareUpdateImage(
        FirmwareUpdateImage.unwrap(firmwareUpdateImage): java.lang.String
      )
      .firmwareUpdateRole(
        FirmwareUpdateRole.unwrap(firmwareUpdateRole): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CreateFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateFuotaTaskRequest.wrap(buildAwsValue())
}
object CreateFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateFuotaTaskRequest =
      zio.aws.iotwireless.model.CreateFuotaTaskRequest(
        name.map(value => value),
        description.map(value => value),
        clientRequestToken.map(value => value),
        loRaWAN.map(value => value.asEditable),
        firmwareUpdateImage,
        firmwareUpdateRole,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[FuotaTaskName]
    def description: Optional[Description]
    def clientRequestToken: Optional[ClientRequestToken]
    def loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly]
    def firmwareUpdateImage: FirmwareUpdateImage
    def firmwareUpdateRole: FirmwareUpdateRole
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def getName: ZIO[Any, AwsError, FuotaTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getFirmwareUpdateImage: ZIO[Any, Nothing, FirmwareUpdateImage] =
      ZIO.succeed(firmwareUpdateImage)
    def getFirmwareUpdateRole: ZIO[Any, Nothing, FirmwareUpdateRole] =
      ZIO.succeed(firmwareUpdateRole)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.CreateFuotaTaskRequest.ReadOnly {
    override val name: Optional[FuotaTaskName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
        )
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANFuotaTask.wrap(value))
    override val firmwareUpdateImage: FirmwareUpdateImage =
      zio.aws.iotwireless.model.primitives
        .FirmwareUpdateImage(impl.firmwareUpdateImage())
    override val firmwareUpdateRole: FirmwareUpdateRole =
      zio.aws.iotwireless.model.primitives
        .FirmwareUpdateRole(impl.firmwareUpdateRole())
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
  ): zio.aws.iotwireless.model.CreateFuotaTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
